﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Dizplay_Cruise
{
    class ChatRoom
    {
        static public void sendRoomMessage(string message, string roomName, byte msgStyle)
        {
            foreach (clsUser U in Form1.Users)
            {
                if (U.IsChattingIn == roomName)
                {
                    sendMessage(U.Username, message, msgStyle);
                }
            }
        }

        static public void sendMessage(string recipientUName, string message, byte msgStyle)
        {
            foreach (clsUser U in Form1.Users)
            {
                int tempMessages1 = 0;
                if (U.Username == recipientUName)
                {
                    if (U.IsChattingMessages == 24)
                    {
                        U.IsChattingMessages += 1;
                    }
                    tempMessages1 = U.IsChattingMessages;
                    if (tempMessages1 <= 24)
                    {
                        Form1.InSim.Send_BTN_CreateButton(message, (Form1.InSim.Flags.ButtonStyles.ISB_LEFT + msgStyle), 4, 75, Convert.ToByte(54 + tempMessages1 * 4), 50, Convert.ToByte(130 + tempMessages1), C.UniqueID, 40, false);
                    }
                    else if (tempMessages1 > 24)
                    {
                        int tempInt2 = tempMessages1;
                        while ((tempInt2 - 24) > 0)
                        {
                            tempInt2 -= 24;
                            //InSim.Send_MST_Message("/msg ^3» ^81: " + tempInt1 + " | 2: " + tempInt2);
                        }

                        while ((C.IsChattingMessages - 24) > 24)
                        {
                            C.IsChattingMessages -= 24;
                        }
                        Form1.InSim.Send_BFN_DeleteButton(LFS_External.Enums.BtnFunc.BFN_DEL_BTN, Convert.ToByte(130 + tempInt2), C.UniqueID);
                        Form1.InSim.Send_BTN_CreateButton(message, (LFS_External.InSim.Flags.ButtonStyles.ISB_LEFT + msgStyle), 4, 75, Convert.ToByte(50 + tempInt2 * 4), 50, Convert.ToByte(129 + tempInt2), C.UniqueID, 40, false);
                    }
                    C.IsChattingMessages += 1;
                }
            }
        }

        static public void sendNormPrivMessage(string recipientUName, string senderPName, string message)
        {
            foreach (clsUser U in Form1.Users)
            {
                if (C.Username == recipientUName)
                {
                    sendMessage(C.Username, senderPName + " ^6PM: " + message.Replace("^8", "^6"), 0);
                }
            }
        }

        static public void sendNormMessage(string username, string message)
        {
            foreach (clsConnection C in Form1.Connections)
            {
                if (C.Username == username)
                {
                    string[] StrMsg = message.Split(' ');
                    if (StrMsg[0].StartsWith("/"))
                    {
                        switch (StrMsg[0])
                        {
                            case "/msg":
                                if (C.IsChattingOwner == 1)
                                {
                                    if (StrMsg.Length > 1)
                                    {
                                        sendRoomMessage(message.Remove(0, StrMsg[0].Length + 1), C.IsChattingIn, 0);
                                    }
                                    else
                                    {
                                        sendMessage(C.Username, "This command needs a parameter", 0);
                                    }
                                }
                                else
                                {
                                    sendMessage(C.Username, "You do not have admin rights", 0);
                                }
                                break;

                            case "/kick":
                                if (C.IsChattingOwner == 1)
                                {
                                    if (StrMsg.Length > 1)
                                    {
                                        foreach (clsConnection C2 in Form1.Connections)
                                        {
                                            if (C2.Username == message.Remove(0, StrMsg[0].Length + 1))
                                            {
                                                if (C2.IsChattingIn == C.IsChattingIn)
                                                {
                                                    sendRoomMessage(C2.PlayerName + " ^8was kicked", C2.IsChattingIn, 7);
                                                    quitRoom(C2);
                                                }
                                                else
                                                {
                                                    sendMessage(C.Username, "The user was not found in the room", 0);
                                                    sendMessage(C.Username, "Entered: " + message.Remove(0, StrMsg[0].Length + 1), 0);
                                                }
                                                return;
                                            }
                                        }
                                        sendMessage(C.Username, "The user was not found in the server", 0);
                                        sendMessage(C.Username, "Entered: " + message.Remove(0, StrMsg[0].Length + 1), 0);
                                    }
                                    else
                                    {
                                        sendMessage(C.Username, "This command needs a parameter", 0);
                                    }
                                }
                                else
                                {
                                    sendMessage(C.Username, "You do not have admin rights", 0);
                                }
                                break;

                            case "/dragin":
                                if (C.IsAdmin == 1)
                                {
                                    if (StrMsg.Length > 1)
                                    {
                                        foreach (clsConnection C2 in Form1.Connections)
                                        {
                                            if (C2.Username == message.Remove(0, StrMsg[0].Length + 1))
                                            {
                                                if (C2.IsChattingIn == "" || C2.IsChattingIn == null)
                                                {
                                                    sendRoomMessage("A new guest is being dragged in", C2.IsChattingIn, 6);
                                                    enterRoom(C2, C.IsChattingIn);
                                                    sendRoomMessage(C2.PlayerName + " ^8joined (" + C2.Username + ")", C.IsChattingIn, 0);
                                                }
                                                else
                                                {
                                                    sendMessage(C.Username, "This user is in (another room) already", 0);
                                                    sendMessage(C.Username, "Entered: " + message.Remove(0, StrMsg[0].Length + 1), 0);
                                                }
                                                return;
                                            }
                                        }
                                        sendMessage(C.Username, "The user was not found in the server", 0);
                                        sendMessage(C.Username, "Entered: " + message.Remove(0, StrMsg[0].Length + 1), 0);
                                    }
                                    else
                                    {
                                        sendMessage(C.Username, "This command needs a parameter", 0);
                                    }
                                }
                                else
                                {
                                    sendMessage(C.Username, "Unknown command", 0);
                                }
                                break;

                            case "/owner":
                                if (C.IsChattingOwner == 1)
                                {
                                    if (StrMsg.Length > 1)
                                    {
                                        foreach (clsConnection C2 in Form1.Connections)
                                        {
                                            if (C2.Username == message.Remove(0, StrMsg[0].Length + 1))
                                            {
                                                if (C2.IsChattingIn == C.IsChattingIn)
                                                {
                                                    sendRoomMessage(C2.PlayerName + " ^8is the new room owner", C2.IsChattingIn, 4);
                                                    C.IsChattingOwner = 0;
                                                    C2.IsChattingOwner = 1;
                                                }
                                                else
                                                {
                                                    sendMessage(C.Username, "The user was not found in the room", 0);
                                                    sendMessage(C.Username, "Entered: " + message.Remove(0, StrMsg[0].Length + 1), 0);
                                                }
                                                return;
                                            }
                                        }
                                        sendMessage(C.Username, "The user was not found in the server", 0);
                                        sendMessage(C.Username, "Entered: " + message.Remove(0, StrMsg[0].Length + 1), 0);
                                    }
                                    else
                                    {
                                        sendMessage(C.Username, "This command needs a parameter", 0);
                                    }
                                }
                                else
                                {
                                    sendMessage(C.Username, "You do not have admin rights", 0);
                                }
                                break;

                            default:
                                if (StrMsg[0].StartsWith("/"))
                                {
                                    sendMessage(C.Username, "Unknown command", 0);
                                }
                                break;
                        }
                    }
                    else
                    {
                        sendRoomMessage(C.PlayerName + " ^7(" + C.Username + ") : " + message.Replace("^8", "^7"), C.IsChattingIn, 0);
                    }
                }
            }
        }

        static public int roomConnCount(string roomName)
        {
            int toReturn = 0;
            foreach (clsConnection C in Form1.Connections)
            {
                if (C.IsChattingIn == roomName)
                {
                    toReturn += 1;
                }
            }
            return toReturn;
        }

        static public void refreshConnections(string roomName)
        {
            foreach (clsConnection C in Form1.Connections)
            {
                if (C.IsChattingIn == roomName)
                {
                    buttonSequence.deleteSequence("chat room cl", C.UniqueID);
                    int shitto2 = 0;
                    foreach (clsConnection CN in Form1.Connections)
                    {
                        if (CN.IsChattingIn == roomName)
                        {
                            Form1.InSim.Send_BTN_CreateButton("" + CN.PlayerName + " ^7(" + CN.Username + ")", LFS_External.InSim.Flags.ButtonStyles.ISB_LEFT, 4, 24, Convert.ToByte(51 + (shitto2 * 4)), 125, Convert.ToByte(106 + shitto2), C.UniqueID, 40, false);
                            shitto2 += 1;
                        }
                    }
                }
            }
        }

        static public void joinRoom(clsConnection C, string roomName)
        {
            sendRoomMessage("A new guest is joining", roomName, 6);
            C.IsChattingIn = roomName;
            C.IsChattingRank = 5;
            buttonSequence.createSequence("chat room", C.UniqueID, C);
            C.Action = "chatting";

            int foundowner = 0;
            foreach (clsConnection C2 in Form1.Connections)
            {
                if (C2.IsChattingIn == C.IsChattingIn)
                {
                    if (C2.IsChattingOwner == 1)
                    {
                        foundowner = 1;
                    }
                }
            }
            if (foundowner == 0)
            {
                C.IsChattingOwner = 1;
                Form1.InSim.Send_MTC_MessageToConnection("^3» ^7This room has no owner. You will now gain the ownership.", C.UniqueID, 0);
            }
            refreshConnections(roomName);
            sendRoomMessage(C.PlayerName + " ^8joined (" + C.Username + ")", roomName, 0);
        }

        static public void leaveRoom(clsConnection C)
        {
            string roomName = C.IsChattingIn;
            sendRoomMessage(C.PlayerName + " ^8left (" + C.Username + ")", roomName, 7);
            if (C.IsChattingOwner == 1)
            {
                int foundOrNot = 0;
                foreach (clsConnection C2 in Form1.Connections)
                {
                    if (C2.IsChattingIn == C.IsChattingIn && C2.Username != C.Username && foundOrNot == 0)
                    {
                        foundOrNot = 1;
                        C2.IsChattingOwner = 1;
                        C2.IsChattingMessages = C.IsChattingMessages;
                        Form1.InSim.Send_MTC_MessageToConnection("^3» ^7The room creator left. You will now gain the ownership.", C2.UniqueID, 0);
                    }
                }
            }
            C.IsChattingIn = "";
            C.IsChattingMessages = 0;
            C.IsChattingOwner = 0;
            C.IsChattingPassword = "";
            buttonSequence.deleteSequence("chat room", C.UniqueID);
            C.Action = "Nothing";
            refreshConnections(roomName);
        }

        static public void enterRoom(clsConnection C, string roomName)
        {
            C.IsChattingIn = roomName;
            C.IsChattingRank = 5;
            buttonSequence.createSequence("chat room", C.UniqueID, C);
            C.Action = "chatting";

            int foundowner = 0;
            foreach (clsConnection C2 in Form1.Connections)
            {
                if (C2.IsChattingIn == C.IsChattingIn)
                {
                    if (C2.IsChattingOwner == 1)
                    {
                        foundowner = 1;
                    }
                }
            }
            if (foundowner == 0)
            {
                C.IsChattingOwner = 1;
                Form1.InSim.Send_MTC_MessageToConnection("^3» ^7This room has no owner. You will now gain the ownership.", C.UniqueID, 0);
            }
            refreshConnections(roomName);
        }

        static public void quitRoom(clsConnection C)
        {
            string roomName = C.IsChattingIn;
            if (C.IsChattingOwner == 1)
            {
                int foundOrNot = 0;
                foreach (clsConnection C2 in Form1.Connections)
                {
                    if (C2.IsChattingIn == C.IsChattingIn && C2.Username != C.Username && foundOrNot == 0)
                    {
                        foundOrNot = 1;
                        C2.IsChattingOwner = 1;
                        C2.IsChattingMessages = C.IsChattingMessages;
                        Form1.InSim.Send_MTC_MessageToConnection("^3» ^1ERROR. ^7You will now gain the ownership.", C2.UniqueID, 0);
                    }
                }
            }
            C.IsChattingIn = "";
            C.IsChattingMessages = 0;
            C.IsChattingOwner = 0;
            C.IsChattingPassword = "";
            buttonSequence.deleteSequence("chat room", C.UniqueID);
            C.Action = "Nothing";
            refreshConnections(roomName);
        }
    }
}
